local ThemeDir = THEME:GetCurrentThemeDirectory()
local map_texture

local af = Def.ActorFrame{ Name="Visuals" }

local aft = Def.ActorFrameTexture{
	Name="AFT",
	InitCommand=function(self)
		self:SetDrawByZPosition(true)
			:SetTextureName("Map")
			:queuecommand("LoadMap")
	end,

	LoadMapCommand=function(self)
		LoadMapData(SRT.ActiveMap)
		self:queuecommand("Render")
	end,
	RenderCommand=function(self)

		-- get the width and height of our to-be-created texture, in pixels
		local texture = {
			w = SRT.TileData.Width.Pixels,
			h = SRT.TileData.Height.Pixels
		}

		self:SetWidth( texture.w )
		self:SetHeight( texture.h )

		-- Create() only needs to be run the first time.
		if not self:GetTexture() then
			self:Create()
		end

		self:Draw()

		-- we'll use map_texture below in the Def.Sprite{}
		-- in conjunection with SetTexture()
		map_texture = self:GetTexture()

		self:GetParent():queuecommand("Load"):queuecommand("SetTexture")
	end,


	-- load the map layer that the player sprite walks "on top of"
	Def.Sprite{
		Name="Under",
		InitCommand=cmd(halign,0; valign,0; z,-500),
		LoadCommand=function(self)
			self:Load(THEME:GetPathB("Overworld", "overlay/Scenes/" .. SRT.ActiveMap .. "/under.png"))
		end
	},

	-- load the PLAYER_1 sprite
	LoadActor("Sprites/Player.lua")..{
		Name="Player_Sprite",
	},


	-- load the map layer that the player sprite walks "underneath"
	-- initialize its z value to be arbitrarily high
	Def.Sprite{
		Name="Over",
		InitCommand=cmd(halign,0; valign,0, z, 900),
		LoadCommand=function(self)
			self:Load(THEME:GetPathB("Overworld", "overlay/Scenes/" .. SRT.ActiveMap .. "/over.png"))
		end
	},

	-- load a fog layer, if available, to be placed over everything
	Def.Sprite{
		Name="Over-Fog",
		InitCommand=function(self)
			SRT.OverFog = self
			self:halign(0):valign(0):z(901)
		end,
		LoadCommand=function(self)
			if SRT.ActiveMap == "Hometown" and IsEndGame() then
				self:Load( ThemeDir .. "BGAnimations/Overworld overlay/Scenes/" .. SRT.ActiveMap .. "/over-fog.png" )
 				self:zoomto(SRT.TileData.Width.Pixels, SRT.TileData.Height.Pixels)
				self:diffusealpha(0.75)
			end
		end,
	},
}

-- add actors as necessary if the event needs one
for i,event in ipairs(SRT.EventData) do
	if event.Actor then
		if type(event.Actor) == "table" then
			aft[#aft+1] = event.Actor
		elseif type(event.Actor) == "function" then
			aft[#aft+1] = event.Actor(i)
		end
	end
end


af[#af+1] = aft

-- this is the sprite that the AFT gets rendered to
af[#af+1] = Def.Sprite{
	Name="Sprite",
	OnCommand=function(self)
		self:halign(0):valign(0)
	end,
	SetTextureCommand=function(self)
		self:SetTexture(map_texture)
		SRT.MapSprite = self
		self:queuecommand("Load")
	end,

	LoadCommand=function(self)

		-- for the sake of initializing the map, place it so the player sprite is visible onscreen
		local MapCenter = FindCenterOfMap()
		self:x(-(MapCenter.right * SRT.TileData.TileSize - _screen.w/2))
		self:y(-(MapCenter.down * SRT.TileData.TileSize - _screen.h/2))

		SRT.MapFade:queuecommand("FadeIn")
	end,
	AttemptToTweenCommand=function(self)

		self:stoptweening()
		self:linear(SRT.SleepDuration)
		local MapCenter = FindCenterOfMap()

		-- update the map's xy position
		self:x(-(MapCenter.right * SRT.TileData.TileSize - _screen.w/2))
		self:y(-(MapCenter.down * SRT.TileData.TileSize - _screen.h/2))
	end
}

af[#af+1] = Def.Quad{
	Name="Fade",
	InitCommand=function(self)
		self:FullScreen():Center():diffuse(0,0,0,1)
		SRT.MapFade = self
	end,
	FadeInCommand=function(self)
		self:sleep(0.15):linear(0.5):diffusealpha(0)
	end,
	FadeOutCommand=function(self)
		self:linear(0.15):diffuse(0,0,0,1)
		self:queuecommand("Transition")
	end,
	TransitionCommand=function(self)
		SRT.ActiveMap = SRT.Transition.NextMap
		SRT.Player.pos = SRT.Transition.NextPos

		SCREENMAN:GetTopScreen():SetNextScreenName("ReloadOverworld"):StartTransitioningScreen("SM_GoToNextScreen")
	end,
	EndGame1Command=function(self)
		self:accelerate(1.5):diffusealpha(1):queuecommand("EndGame2")
	end,
	EndGame2Command=function(self)
		local topscreen = SCREENMAN:GetTopScreen()
		topscreen:SetNextScreenName("Ending")
		topscreen:GetChild("Overlay"):queuecommand("TransitionScreen")
	end
}


return af